<?php
$host = "webdev.iyaserver.com";
$userid = "dhreid";
$userpw = "BlueGrass973cpa";
$db   = "dhreid_class_schedule";

$mysqli = mysqli_connect($host, $userid, $userpw, $db);
if (!$mysqli) { die("DB connect error: ".mysqli_connect_error()); }

$qRaw    = isset($_GET['q'])    ? trim($_GET['q'])    : '';
$roomRaw = isset($_GET['room']) ? trim($_GET['room']) : '';

function like_wrap($conn, $s){
    if ($s === '') return '%';
    $s = str_replace(['%','_'], ['\%','\_'], $s);
    return '%'.mysqli_real_escape_string($conn,$s).'%';
}
$qLike    = like_wrap($mysqli, $qRaw);
$roomLike = like_wrap($mysqli, $roomRaw);


$sql = "
  SELECT
    DAY(cm.meeting_date)                                 AS day_of_month,
    DATE_FORMAT(cm.start_time, '%h:%i %p')               AS start_time,
    CONCAT(l.building_code,' ',l.room)                   AS classroom,
    CONCAT(c.course_code, ': ', c.course_title)          AS class_name,
    mt.meeting_type                                      AS class_type
  FROM class_meetings cm
  JOIN courses c        ON c.course_id        = cm.course_id
  JOIN locations l      ON l.location_id      = cm.location_id
  JOIN meeting_types mt ON mt.meeting_type_id = cm.meeting_type_id
  WHERE CONCAT(c.course_code,' ',c.course_title) LIKE '$qLike'
    AND CONCAT(l.building_code,' ',l.room)     LIKE '$roomLike'
  ORDER BY cm.meeting_date, cm.start_time, class_name
";

$res = mysqli_query($mysqli, $sql);
if (!$res) { die("Query error: ".mysqli_error($mysqli)); }
$rows = [];
while ($r = mysqli_fetch_assoc($res)) { $rows[] = $r; }
$count = count($rows);
?>
<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Class Results</title>
    <style>
        .wrap{width:900px;max-width:95%;margin:40px auto;font-family:Arial,Helvetica,sans-serif}
        table{width:100%;border-collapse:collapse}
        th,td{border-bottom:1px solid #eee;padding:8px;text-align:left}
        .muted{color:#666}
    </style>
</head>
<body>
<div class="wrap">
    <h1>Class Search Results</h1>
    <p class="muted">
        Searched for class “<?php echo htmlspecialchars($qRaw,ENT_QUOTES); ?>”
        and room “<?php echo htmlspecialchars($roomRaw,ENT_QUOTES); ?>”.
        <?php echo $count; ?> record<?php echo $count==1?'':'s'; ?> found.
    </p>

    <table>
        <tr>
            <th></th>
            <th>Day</th>
            <th>Start Time</th>
            <th>Classroom</th>
            <th>Class Name</th>
            <th>Class Type</th>
        </tr>
        <?php if ($count==0): ?>
            <tr><td colspan="6" class="muted">No matches. Try broader terms.</td></tr>
        <?php else: foreach ($rows as $r): ?>
            <tr>
                <td>✏️</td>
                <td><?php echo htmlspecialchars($r['day_of_month']); ?></td>
                <td><?php echo htmlspecialchars($r['start_time']); ?></td>
                <td><?php echo htmlspecialchars($r['classroom']); ?></td>
                <td><?php echo htmlspecialchars($r['class_name']); ?></td>
                <td><?php echo htmlspecialchars($r['class_type']); ?></td>
            </tr>
        <?php endforeach; endif; ?>
    </table>

    <p><a href="ClassSearch.php">Back to search</a></p>
</div>
</body>
</html>
<?php mysqli_close($mysqli); ?>
