<?php
session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>USC Student Marketplace</title>
    <link rel="stylesheet" href="stylesheet.css">
</head>
<body>

<?php require_once __DIR__ . '/nav.php'; ?>

<section class="hero hero-video" id="home" aria-label="Hero video">
    <video class="hero-video__bg" autoplay muted loop playsinline>
        <source src="hero-video.mp4" type="video/mp4">
    </video>

    <div class="hero-video__overlay">
        <div class="hero-video__content">
            <h1>Buy, Sell & Trade Smarter at USC</h1>
            <p>A secure, student-verified platform connecting Trojans to exchange dorm essentials and more — safely, easily, and sustainably.</p>
            <a class="btn primary hero-btn" href="search.php">Start Trading</a>
        </div>
    </div>
</section>


<main class="wrap">

    <section class="section featured">
        <h2>20% Off Campus Picks</h2>
        <p>Shop verified student favorites — from tech to dorm essentials.</p>

        <div class="featured-grid">
            <div class="featured-item"><img src="https://i.ibb.co/jZ5W5K5G/headphones.png" ><span>Headphones</span></div>
            <div class="featured-item"><img src="https://i.ibb.co/Jw4DCcfm/purse.png" ><span>Clothing</span></div>
            <div class="featured-item"><img src="https://i.ibb.co/rKQyQ36t/mouse.png" ><span>Electronics</span></div>
            <div class="featured-item"><img src="https://i.ibb.co/4R8YnZFW/keyboard.png" ><span>Entertainment</span></div>
            <div class="featured-item"><img src="https://i.ibb.co/Qj13mLWp/table.png" ><span>Furniture</span></div>

        </div>
    </section>

    <section class="section edit">
        <div class="edit-header">
            <h2>The Trojan Edit</h2>
            <a href="#" class="see-more">See more →</a>
        </div>

        <div class="edit-grid">
            <?php

            $host   = "webdev.iyaserver.com";
            $userid = "dhreid_guest";
            $userpw = "tPTG;A+J{]Ze";
            $db     = "dhreid_marketplace";

            $mysql = new mysqli($host, $userid, $userpw, $db);
            if ($mysql->connect_errno) {
                die("DB connection error: " . $mysql->connect_error);
            }

            $signup_success = $_SESSION['signup_success'] ?? "";
            unset($_SESSION['signup_success']);

            $error = "";
            $sql = "
                SELECT
                    i.item_id AS item_id,
                    i.title AS title,
                    i.price_cents AS price_cents,
                    COALESCE(l.label, '') AS location_label,
                    COALESCE(img.url, '') AS image_url
                FROM items i
                LEFT JOIN locations l
                    ON l.location_id = i.location_id
                LEFT JOIN item_images img
                    ON img.item_id = i.item_id
                ORDER BY i.item_id DESC
                LIMIT 6
            ";
            $result = $mysql->query($sql);

            if ($result === false) {
                echo '<p>SQL error: ' . htmlspecialchars($mysql->error) . '</p>';
            } elseif ($result->num_rows === 0) {
                echo '<p>No items available right now.</p>';
            } else {
                while ($row = $result->fetch_assoc()) {

                    $item_id = (int)($row['item_id'] ?? 0);
                    $title   = htmlspecialchars($row['title'] ?? '');

                    // Price
                    $price_cents = isset($row['price_cents']) ? (int)$row['price_cents'] : 0;
                    $price_dollars = number_format($price_cents / 100, 2);

                    // Location (label from locations table)
                    $location_label = trim((string)($row['location_label'] ?? ''));
                    $location_label = $location_label !== '' ? htmlspecialchars($location_label) : 'Unknown';

                    // Image
                    $image = trim((string)($row['image_url'] ?? ''));
                    $image = $image !== '' ? htmlspecialchars($image) : 'images/placeholder.png';
                    ?>
                    <article class="card">
                        <span class="thumb" style="background-image:url('<?php echo $image; ?>')"></span>

                        <div class="meta">
                            <h3 class="title"><?php echo $title; ?></h3>
                            <div><span class="price">$<?php echo $price_dollars; ?></span></div>
                            <div class="meet">Pickup: <?php echo $location_label; ?></div>
                        </div>

                        <div class="actions">
                            <a class="btn primary" href="details_page.php?item_id=<?php echo $item_id; ?>">
                                View Details
                            </a>
                        </div>
                    </article>
                    <?php
                }
            }
            ?>
        </div>




    </section>




    <section class="section price-cards">
        <h2>Shop by Price</h2>
        <div class="price-grid">
            <a href="search.php?price_cents_max=1000"  class="price-card">Under $10</a>
            <a href="search.php?price_cents_max=2000"  class="price-card">Under $20</a>
            <a href="search.php?price_cents_max=5000"  class="price-card">Under $50</a>
            <a href="search.php?price_cents_max=10000" class="price-card">Under $100</a>
        </div>
    </section>
    <br>

    <section class="section post-cta" style="background:#f7f7f8" >
        <div class="edit-header">
            <h2 style="color:#1f2328">How to sell in 3 easy steps</h2>
        </div>

        <div class="grid">

            <!-- Step 1 -->
            <article class="card">
      <span
              class="thumb"
              style="background-image:url('https://valyoufurniture.com/cdn/shop/articles/c_d2ef99c1-0449-4a07-a66e-aaa4c2aea126.jpg?v=1747679399&width=2048')">
      </span>
                <div class="meta">
                    <h3 class="title" style="color:var(--text);">Snap a few photos <span class="badge">Step 1</span></h3>
                    <div class="meet">Good light, clear angles, and any wear—keep it honest.</div>
                </div>
            </article>

            <!-- Step 2 -->
            <article class="card">
      <span
              class="thumb"
              style="background-image:url('https://accidentallywesanderson.com/wp-content/uploads/2024/08/IMG_4623-scaled-3.jpeg')">
      </span>
                <div class="meta">
                    <h3 class="title">Pick a meetup spot <span class="badge">Step 2</span></h3>
                    <div class="meet">Choose a convenient, well-lit location on or near campus.</div>
                </div>
            </article>

            <!-- Step 3 -->
            <article class="card">
      <span
              class="thumb"
              style="background-image:url('https://media.istockphoto.com/id/92806038/photo/easy-money-24.jpg?s=612x612&w=0&k=20&c=KriE2FQL4xYhvJPiO86aoTWEf6LML49liKeLJkeyX8I=')">
      </span>
                <div class="meta">
                    <h3 class="title">Confirm the price <span class="badge">Step 3</span></h3>
                    <div class="meet">Agree on a price, hand off the item, and you’re done.</div>
                </div>
            </article>

        </div>


        <div class="actions" style="justify-content:center;">
            <a href="listing.php" class="btn primary" style="max-width:280px;">Start Selling</a>
        </div>
    </section>



</main>

<footer>
    © 2025 USC Student Marketplace · Built by Trojans for Trojans
</footer>

</body>
</html>
