<?php
session_start();

// Pull seller email from the query string (from search.php Contact link)
$seller_email = $_REQUEST['seller_email'] ?? '';

// Pull buyer name/email from session if present
$buyer_name_from_session  = $_SESSION['full_name']  ?? '';
$buyer_email_from_session = $_SESSION['usc_email']  ?? '';

// Determine who email should be sent to
$destinationemail = $_REQUEST['destinationemail'] ?? $seller_email;

// If no seller email is provided
if (empty($destinationemail) && empty($_REQUEST['userfeedback'])) {
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <script async src="https://www.googletagmanager.com/gtag/js?id=G-FEM3Q0G7NZ"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());

            gtag('config', 'G-FEM3Q0G7NZ');
        </script>
        <title>Contact Seller</title>
    </head>
    <body style="font-family: sans-serif; padding: 20px;">
    <h2>Missing seller email</h2>
    <p>This page was opened without a seller email address.</p>
    <p><a href="search.php">Back to marketplace</a></p>
    </body>
    </html>
    <?php
    exit();
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Contact Seller</title>

    <style>
        /* USC Cardinal and Gold Theme */
        :root {
            --usc-cardinal: #990000;
            --usc-gold: #FFCC00;
            --usc-cardinal-dark: #7A0000;
        }

        body {
            background-color: var(--usc-cardinal);
            font-family: Arial, sans-serif;
        }

        #container {
            background-color: white;
            width: 450px;
            margin: auto;
            padding: 25px;
            margin-top: 40px;
            border-radius: 10px;
            border: 3px solid var(--usc-gold);
            box-shadow: 0 0 10px rgba(0,0,0,0.25);
        }

        h1 {
            color: var(--usc-cardinal);
            margin-top: 0;
            font-style: italic;
            text-align: center;
        }

        h2 {
            color: var(--usc-cardinal);
            font-weight: bold;
        }

        hr {
            border: 1px solid var(--usc-gold);
        }

        input, textarea {
            width: 100%;
            padding: 6px;
            border: 1px solid #CCC;
            border-radius: 5px;
            margin-top: 4px;
        }

        textarea {
            height: 90px;
        }

        input[type='submit'] {
            padding: 10px;
            border-radius: 6px;
            color: white;
            background-color: var(--usc-cardinal);
            cursor: pointer;
            font-weight: bold;
            border: none;
            width: 100%;
            margin-top: 12px;
        }

        input[type='submit']:hover {
            background-color: var(--usc-cardinal-dark);
        }

        a {
            color: var(--usc-cardinal);
            font-weight: bold;
        }
    </style>
</head>

<body>
<div id="container">
    <?php
    // ======================== SHOW FORM ========================
    if (empty($_REQUEST["userfeedback"])) {
        ?>
        <h1>Contact the Seller</h1>
        <hr/>

        <form action="" method="get">

            <label>Email to send form to:</label>
            <input type="text" name="destinationemail"
                   value="<?php echo htmlspecialchars($destinationemail); ?>" />
            <br/><br>

            <label>Your Email:</label>
            <input type="text" name="useremail"
                   value="<?php echo htmlspecialchars($buyer_email_from_session); ?>" />
            <br/><br>

            <label>Subject:</label>
            <input type="text" name="usersubject"
                   value="USC Marketplace Inquiry" />
            <br/><br>

            <label>Message to the seller:</label>
            <textarea name="userfeedback"></textarea>
            <br/><br>

            <input type="submit" value="Send Email"/>

        </form>

        <?php
// ======================== SEND EMAIL ========================
    } else {

        $to       = $_REQUEST["destinationemail"];
        $subject  = $_REQUEST["usersubject"];
        $message  = $_REQUEST["userfeedback"];
        $from     = $_REQUEST["useremail"];

        // Validate email
        if (empty($to)) {
            echo "<h2>Error</h2>";
            echo "<p>Seller email address is missing.</p>";
            echo '<p><a href="emailSeller.php?seller_email=' . htmlspecialchars($seller_email) . '">Go back</a></p>';
            exit();
        }

        // Build header
        $headers = "From: <" . trim($from) . ">";

        $test = mail($to, $subject, $message, $headers);

        if ($test == 1) {
            echo "<h1>Thank You</h1>";
            echo "<p>Your message was successfully sent to:<br><strong>" . htmlspecialchars($to) . "</strong></p>";
            echo "<hr>";
            echo "<p><a href='search.php'>Back to Marketplace</a></p>";
        } else {
            echo "<h1>Error</h1>";
            echo "<p>Your email was not sent. Server Response: $test</p>";
        }

        exit();
    }
    ?>
</div>
</body>
</html>