<?php
session_start();

// ---------------------
// DATABASE CONNECTION
// ---------------------
$host   = "webdev.iyaserver.com";
$userid = "dhreid_guest";
$userpw = "tPTG;A+J{]Ze";
$db     = "dhreid_marketplace";

$mysql = new mysqli($host, $userid, $userpw, $db);
if ($mysql->connect_errno) {
    echo "DB error: " . $mysql->connect_error;
    exit();
}

// ---------------------
// GET USER ID (fallback)
// ---------------------
$user_id = $_SESSION['user_id'] ?? 25;

// ---------------------
// FETCH USER INFO
// ---------------------
$user_q = $mysql->prepare("SELECT full_name, usc_email, phone FROM users WHERE user_id = ?");
$user_q->bind_param("i", $user_id);
$user_q->execute();
$user = $user_q->get_result()->fetch_assoc();

// fallback display
$full_name = $user['full_name'] ?? "Username";
$usc_email = $user['usc_email'] ?? "example@usc.edu";
$phone_number = $user['phone'] ?? "1234567890";

// Generate handle from email before '@'
$handle = '';
if (!empty($usc_email)) {
    $parts = explode('@', $usc_email);
    $handle = '@' . $parts[0];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-FEM3Q0G7NZ"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', 'G-FEM3Q0G7NZ');
    </script>
    <meta charset="UTF-8">
    <title>Student Profile</title>
    <style>
        :root {
            --usc-cardinal: #990000;
            --usc-gold: #FFC72C;
            --gray-bg: #f4f4f6;
            --card-bg: #ffffff;
            --border: #e5e7eb;
            --text-main: #222;
            --text-muted: #6b7280;
        }

        body {
            margin: 0;
            padding: 40px 0;
            font-family: Inter, -apple-system, BlinkMacSystemFont, sans-serif;
            background: var(--gray-bg);
            display: flex;
            justify-content: center;
        }

        .page-wrap {
            width: 100%;
            max-width: 1100px;
            padding: 0 24px;
        }

        .back-link {
            font-size: 14px;
            color: #555;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 4px;
            margin-bottom: 12px;
        }

        .back-link:hover {
            text-decoration: underline;
        }

        h1 {
            margin: 0 0 16px;
            font-size: 24px;
            font-weight: 700;
            color: var(--text-main);
        }

        .welcome-name {
            font-weight: 600;
        }

        /* ---- Main Card ---- */
        .profile-card {
            background: var(--card-bg);
            border-radius: 16px;
            box-shadow: 0 12px 30px rgba(0,0,0,0.08);
            overflow: hidden;
        }

        /* ---- Solid Top Bar ---- */
        .profile-banner {
            background: var(--usc-cardinal);
            height: 60px;          /* narrower maroon bar */
            width: 100%;
            border-radius: 14px 14px 0 0;
        }

        /* ---- Card Content ---- */
        .profile-content {
            padding: 24px 32px 32px;
            display: grid;
            grid-template-columns: 1.2fr 1fr;
            gap: 32px;
        }

        @media (max-width: 850px) {
            .profile-content {
                grid-template-columns: 1fr;
            }
        }

        /* ---- Left Column ---- */
        .left-column {
            display: flex;
            flex-direction: column;
        }

        .top-profile {
            display: flex;
            align-items: center;
            gap: 16px;
            /* OLD: margin-top: -40px;  (overlaps the bar) */
            margin-top: 20px;      /* ✅ now 20px below the top bar */
            margin-bottom: 26px;
        }

        .avatar-img {
            width: 60px;   /* smaller logo */
            height: 60px;
            border-radius: 50%;
            background: var(--usc-cardinal);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 32px;
            font-weight: 700;
            color: white;
        }

        .avatar-img img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .user-handle {
            font-size: 15px;
            font-weight: 600;
        }

        .user-email {
            font-size: 13px;
            color: var(--text-muted);
        }

        .profile-field-label {
            font-size: 13px;
            font-weight: 600;
            margin-bottom: 4px;
            color: var(--text-main);
        }

        .profile-input {
            width: 100%;
            padding: 10px 12px;
            border-radius: 8px;
            border: 1px solid var(--border);
            font-size: 14px;
            margin-bottom: 16px;
            background: #f9fafb;
        }

        .profile-input::placeholder {
            color: #9ca3af;
        }

        .profile-input:focus {
            outline: 2px solid var(--usc-cardinal);
            outline-offset: 1px;
            background: #ffffff;
        }

        .btn-red {
            background: var(--usc-cardinal);
            color: white;
            border: none;
            border-radius: 999px;
            padding: 10px 18px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            margin-top: 6px;
        }

        .btn-red:hover {
            background: #7a0000;
        }

        /* ---- Right Column (Saved Items) ---- */
        .right-column {
            border-left: 1px solid var(--border);
            padding-left: 24px;
        }

        @media (max-width: 850px) {
            .right-column {
                border-left: none;
                border-top: 1px solid var(--border);
                padding-left: 0;
                padding-top: 22px;
            }
        }

        .section-title {
            font-size: 15px;
            font-weight: 600;
            margin-bottom: 12px;
        }

        .section-subtitle {
            font-size: 13px;
            color: var(--text-muted);
            margin-bottom: 16px;
        }

        .saved-list {
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .saved-item {
            display: grid;
            grid-template-columns: 64px 1fr auto;
            gap: 12px;
            align-items: center;
            padding: 8px 10px;
            border-radius: 10px;
            border: 1px solid var(--border);
            background: #f9fafb;
        }

        .saved-thumb {
            width: 64px;
            height: 64px;
            border-radius: 8px;
            background-size: cover;
            background-position: center;
            background-color: #e5e7eb;
        }

        .saved-info-title {
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 2px;
        }

        .saved-info-meta {
            font-size: 12px;
            color: var(--text-muted);
        }

        .saved-price {
            font-size: 14px;
            font-weight: 700;
            color: var(--usc-cardinal);
        }

        .empty-message {
            font-size: 13px;
            color: var(--text-muted);
            font-style: italic;
        }

        /* ---- Arrow Placeholder ---- */
        .arrow {
            font-size: 22px;
            color: #999;
            margin-top: 40px;
        }
    </style>
</head>
<body>
<div class="page-wrap">

    <a href="search.php" class="back-link">
        ← Back
    </a>

    <h1>Welcome, <span class="welcome-name"><?php echo htmlspecialchars($full_name); ?></span></h1>

    <div class="profile-card">

        <div class="profile-banner"></div>

        <div class="profile-content">

            <!-- LEFT COLUMN -->
            <div class="left-column">

                <div class="top-profile">
                    <div class="avatar-img">
                        <img src="USCLOGO.png" alt="USC Logo" class="avatar-icon">
                    </div>

                    <div>
                        <div class="user-handle"><?php echo $handle; ?></div>
                        <div class="user-email"><?php echo htmlspecialchars($usc_email); ?></div>
                    </div>
                </div>

                <div class="profile-field-label">Full Name</div>
                <input class="profile-input" placeholder="Your First Name" value="<?php echo htmlspecialchars($full_name); ?>">

                <div class="profile-field-label">Phone Number</div>
                <input class="profile-input" placeholder="Phone Number" value="<?php echo htmlspecialchars($phone_number); ?>">

                <div class="profile-field-label">Email </div>
                <input class="profile-input" placeholder="Email" value="<?php echo htmlspecialchars($usc_email); ?>">


                <!--   <button class="btn-red">View Saved Items</button> -->

            </div>

            <!-- RIGHT COLUMN -->
            <div class="right-column">
                <div class="section-title">Saved Items</div>
                <div class="section-subtitle">Items you’ve saved from the marketplace</div>

                <div class="saved-list">
                    <!-- Placeholder: replace with dynamic saved items later -->
                    <div class="empty-message">You haven’t saved any items yet.</div>
                </div>
            </div>

        </div>
    </div>

</div>
</body>
</html>