<?php
session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-FEM3Q0G7NZ"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', 'G-FEM3Q0G7NZ');
    </script>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Safety • USC Student Marketplace</title>
    <link rel="stylesheet" href="stylesheet.css">
</head>

<body>


<?php include 'nav.php'; ?>

<main class="wrap">

    <!-- SAFETY INTRO -->
    <section id="safety" class="section">
        <h1>Safety Guidelines</h1>
        <p>
            Your safety is our top priority. The USC Student Marketplace is built with
            student verification, trusted signals, and protective design features that make
            buying, selling, and trading safer and more transparent for everyone.
        </p>
    </section>

    <!-- SAFETY FEATURES -->
    <section class="section">
        <h2>Built-In Safety Features</h2>

        <div class="grid">

            <!-- Feature 1 -->
            <article class="card">
                <span class="thumb" style="background-image:url('https://images.pexels.com/photos/3183186/pexels-photo-3183186.jpeg')"></span>
                <div class="meta">
                    <h3 class="title">USC Email Verification</h3>
                    <p>
                        Only @usc.edu accounts can join — ensuring all buyers and sellers are
                        real USC students.
                    </p>
                </div>
            </article>

            <!-- Feature 2 -->
            <article class="card">
                <span class="thumb" style="background-image:url('https://images.pexels.com/photos/3817851/pexels-photo-3817851.jpeg')"></span>
                <div class="meta">
                    <h3 class="title">Recommended Meetup Locations</h3>
                    <p>
                        The platform highlights well-lit, high-traffic campus spots like
                        USC Village, Leavey, and Commons areas for safe exchanges.
                    </p>
                </div>
            </article>

            <!-- Feature 3 -->
            <article class="card">
                <span class="thumb" style="background-image:url('https://images.pexels.com/photos/3184643/pexels-photo-3184643.jpeg')"></span>
                <div class="meta">
                    <h3 class="title">Safety-Forward Algorithm</h3>
                    <p>
                        Listings with clear photos, honest descriptions, and verified profiles
                        are boosted, promoting trustworthy interactions.
                    </p>
                </div>
            </article>

        </div>
    </section>

    <!-- SAFETY TIPS -->
    <section class="section" style="background:#f7f7f8;">
        <h2>Trojan Safety Tips</h2>
        <ul style="line-height:1.7;">
            <li>Meet in public, well-lit campus locations.</li>
            <li>Bring a friend when picking up large items.</li>
            <li>Inspect the item before finalizing the exchange.</li>
            <li>Keep communication inside the platform.</li>
            <li>If anything feels uncomfortable, leave immediately.</li>
        </ul>
    </section>

</main>

<footer>
    © 2025 USC Student Marketplace · Built by Trojans for Trojans
</footer>

</body>
</html>